/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.FluidState;
import net.minecraft.resources.IResource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.WriterBiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.exception.SilentException;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapWriter {
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int loadDistance;
    private int startTileChunkX;
    private int startTileChunkZ;
    private int endTileChunkX;
    private int endTileChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private boolean clearCachedColours;
    private MapBlock loadingObject;
    private OverlayBuilder overlayBuilder;
    private final BlockPos.Mutable mutableLocalPos;
    private final BlockPos.Mutable mutableGlobalPos;
    private int[] biomeBuffer;
    private Random usedRandom = new Random(0L);
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private BlockStateColorTypeCache colorTypeCache;
    private MapProcessor mapProcessor;
    private ArrayList<BlockState> buggedStates;
    private WriterBiomeInfoSupplier writerBiomeInfoSupplier;
    private int topH;
    private HashMap<String, Integer> textureColours;
    private HashMap<BlockState, Integer> blockColours;

    public MapWriter(OverlayManager overlayManager, BlockStateColorTypeCache colorTypeCache) {
        this.loadingObject = new MapBlock();
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new BlockPos.Mutable();
        this.mutableGlobalPos = new BlockPos.Mutable();
        this.biomeBuffer = new int[3];
        this.colorTypeCache = colorTypeCache;
        this.buggedStates = new ArrayList();
        this.writerBiomeInfoSupplier = new WriterBiomeInfoSupplier((BlockPos)this.mutableGlobalPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender(BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager) {
        block20: {
            long before = System.nanoTime();
            try {
                if (WorldMap.crashHandler.getCrashedBy() != null) break block20;
                Object object = this.mapProcessor.renderThreadPauseSync;
                synchronized (object) {
                    if (!this.mapProcessor.isWritingPaused() && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && this.mapProcessor.isCurrentMultiworldWritable()) {
                        if (this.mapProcessor.getWorld() == null || !this.mapProcessor.caveStartIsDetermined() || this.mapProcessor.isCurrentMapLocked()) {
                            return;
                        }
                        if (this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.ignoreWorld((World)this.mapProcessor.getWorld()) && (WorldMap.settings.updateChunks || WorldMap.settings.loadChunks)) {
                            long passed;
                            double playerZ;
                            double playerY;
                            double playerX;
                            Object object2 = this.mapProcessor.mainStuffSync;
                            synchronized (object2) {
                                if (this.mapProcessor.mainWorld != this.mapProcessor.getWorld()) {
                                    return;
                                }
                                playerX = this.mapProcessor.mainPlayerX;
                                playerY = this.mapProcessor.mainPlayerY;
                                playerZ = this.mapProcessor.mainPlayerZ;
                            }
                            XaeroWorldMapCore.ensureField();
                            int lengthX = this.endTileChunkX - this.startTileChunkX + 1;
                            int lengthZ = this.endTileChunkZ - this.startTileChunkZ + 1;
                            if (this.lastWriteTry == -1L) {
                                lengthX = 3;
                                lengthZ = 3;
                            }
                            int sizeTileChunks = lengthX * lengthZ;
                            int sizeTiles = sizeTileChunks * 4 * 4;
                            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
                            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
                            long time = System.currentTimeMillis();
                            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
                            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                                this.framesFreedTime = time;
                                this.writeFreeSizeTiles = sizeTiles;
                                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                                this.workingFrameCount = 0;
                            }
                            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
                            if (this.framesFreedTime != -1L) {
                                sinceLastWrite = time - this.framesFreedTime;
                            }
                            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
                            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                                this.lastWrite = time;
                            }
                            if (tilesToUpdate != 0L) {
                                if (this.framesFreedTime == -1L) {
                                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                                    long writeStartNano = System.nanoTime();
                                    MutableRegistry<Biome> biomeRegistry = this.mapProcessor.worldBiomeRegistry;
                                    boolean loadChunks = WorldMap.settings.loadChunks;
                                    boolean updateChunks = WorldMap.settings.updateChunks;
                                    boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
                                    boolean flowers = WorldMap.settings.flowers;
                                    boolean detailedDebug = WorldMap.settings.detailed_debug;
                                    int i = 0;
                                    while ((long)i < tilesToUpdate) {
                                        this.writeMap((World)this.mapProcessor.getWorld(), playerX, playerY, playerZ, biomeRegistry, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug);
                                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                                        ++i;
                                    }
                                    ++this.workingFrameCount;
                                } else {
                                    this.writeFreeSinceLastWrite = sinceLastWrite;
                                    this.framesFreedTime = -1L;
                                }
                            }
                            this.lastWriteTry = time;
                        }
                    }
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMap(World world, double playerX, double playerY, double playerZ, MutableRegistry<Biome> biomeRegistry, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug) {
        boolean onlyLoad = loadChunks && (!updateChunks || this.updateCounter % 5L != 0L);
        World world2 = world;
        synchronized (world2) {
            if (this.insideX == 0 && this.insideZ == 0) {
                this.playerChunkX = (int)Math.floor(playerX) >> 4;
                this.playerChunkZ = (int)Math.floor(playerZ) >> 4;
                this.loadDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c;
                this.startTileChunkX = this.playerChunkX - this.loadDistance >> 2;
                this.startTileChunkZ = this.playerChunkZ - this.loadDistance >> 2;
                this.endTileChunkX = this.playerChunkX + this.loadDistance >> 2;
                this.endTileChunkZ = this.playerChunkZ + this.loadDistance >> 2;
            }
            this.writeChunk(world, this.loadDistance, onlyLoad, biomeRegistry, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChunk(World world, int distance, boolean onlyLoad, MutableRegistry<Biome> biomeRegistry, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug) {
        int result = 1;
        int tileChunkX = this.startTileChunkX + this.X;
        int tileChunkZ = this.startTileChunkZ + this.Z;
        int tileChunkLocalX = tileChunkX & 7;
        int tileChunkLocalZ = tileChunkZ & 7;
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapRegion region = this.mapProcessor.getMapRegion(regionX, regionZ, true);
        MapTileChunk tileChunk = null;
        MapTileChunk rightChunk = null;
        MapTileChunk bottomChunk = null;
        MapTileChunk bottomRightChunk = null;
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    if (region.getLoadState() == 2) {
                        region.registerVisit();
                    }
                    if (regionIsResting = region.isResting()) {
                        region.setBeingWritten(true);
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (region.getLoadState() == 2 && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                        } else if (!(region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.getLoadState() != 0 && region.getLoadState() != 4)) {
                            this.mapProcessor.getMapSaveLoad().requestLoad(region, "writing");
                        }
                    }
                }
                if (regionIsResting && region.getLoadState() == 2 && tileChunk != null && tileChunk.getLoadState() == 2) {
                    if (!tileChunk.getLeafTexture().shouldUpload()) {
                        int caveStart = this.mapProcessor.getCaveStart();
                        int chunkX = tileChunkX * 4 + this.insideX;
                        int chunkZ = tileChunkZ * 4 + this.insideZ;
                        if (chunkX >= this.playerChunkX - distance && chunkX < this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ < this.playerChunkZ + distance) {
                            Chunk chunk = (Chunk)world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false);
                            MapTile mapTile = tileChunk.getTile(this.insideX, this.insideZ);
                            boolean chunkUpdated = false;
                            try {
                                chunkUpdated = chunk != null && (mapTile == null || (Boolean)XaeroWorldMapCore.chunkCleanField.get(chunk) == false);
                            }
                            catch (IllegalAccessException | IllegalArgumentException e) {
                                throw new RuntimeException(e);
                            }
                            if (chunkUpdated && !(chunk instanceof EmptyChunk)) {
                                boolean edgeChunk = false;
                                block16: for (int i = -1; i < 2; ++i) {
                                    for (int j = -1; j < 2; ++j) {
                                        Chunk neighbor;
                                        if (i == 0 && j == 0 || (neighbor = world.func_212866_a_(chunkX + i, chunkZ + j)) != null && !(neighbor instanceof EmptyChunk)) continue;
                                        edgeChunk = true;
                                        break block16;
                                    }
                                }
                                if (!edgeChunk && (mapTile == null && loadChunks || mapTile != null && updateChunks && !onlyLoad)) {
                                    if (mapTile == null) {
                                        mapTile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                                        tileChunk.setChanged(true);
                                    }
                                    MapTileChunk prevTileChunk = tileChunk.getNeighbourTileChunk(0, -1, this.mapProcessor, false);
                                    MapTileChunk prevTileChunkDiagonal = tileChunk.getNeighbourTileChunk(-1, -1, this.mapProcessor, false);
                                    MapTileChunk prevTileChunkHorisontal = tileChunk.getNeighbourTileChunk(-1, 0, this.mapProcessor, false);
                                    int sectionBasedHeight = this.getSectionBasedHeight(chunk, 64);
                                    Heightmap.Type typeWorldSurface = Heightmap.Type.WORLD_SURFACE;
                                    MapTile bottomTile = this.insideZ < 3 ? tileChunk.getTile(this.insideX, this.insideZ + 1) : null;
                                    MapTile rightTile = this.insideX < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ) : null;
                                    for (int x = 0; x < 16; ++x) {
                                        for (int z = 0; z < 16; ++z) {
                                            int startHeight;
                                            if (caveStart != -1) {
                                                startHeight = caveStart;
                                            } else {
                                                int mappedHeight = chunk.func_201576_a(typeWorldSurface, x, z);
                                                startHeight = ignoreHeightmaps || mappedHeight == -1 ? sectionBasedHeight : mappedHeight + 3;
                                            }
                                            MapBlock currentPixel = mapTile.isLoaded() ? mapTile.getBlock(x, z) : null;
                                            this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, 0, caveStart != -1, mapTile.wasWrittenOnce(), biomeRegistry, flowers);
                                            this.loadingObject.fixHeightType(x, z, mapTile, tileChunk, prevTileChunk, prevTileChunkDiagonal, prevTileChunkHorisontal, this.loadingObject.getHeight(), true);
                                            boolean equalsSlopesExcluded = this.loadingObject.equalsSlopesExcluded(currentPixel);
                                            boolean fullyEqual = this.loadingObject.equals(currentPixel, equalsSlopesExcluded);
                                            if (fullyEqual) continue;
                                            mapTile.setBlock(x, z, this.loadingObject);
                                            this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                            if (!equalsSlopesExcluded) {
                                                boolean xEdge;
                                                tileChunk.setChanged(true);
                                                boolean zEdge = z == 15;
                                                boolean bl = xEdge = x == 15;
                                                if (zEdge) {
                                                    if (bottomTile == null && this.insideZ == 3 && tileChunkLocalZ < 7) {
                                                        if (bottomChunk == null && (bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1)) != null) {
                                                            bottomChunk.setChanged(true);
                                                        }
                                                        MapTile mapTile2 = bottomTile = bottomChunk != null ? bottomChunk.getTile(this.insideX, 0) : null;
                                                    }
                                                    if (bottomTile != null) {
                                                        bottomTile.getBlock(x, 0).setSlopeUnknown(true);
                                                        if (!xEdge) {
                                                            bottomTile.getBlock(x + 1, 0).setSlopeUnknown(true);
                                                        }
                                                    }
                                                    if (xEdge) {
                                                        MapTile bottomRightTile;
                                                        MapTile mapTile3 = bottomRightTile = this.insideX < 3 && this.insideZ < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ + 1) : null;
                                                        if (bottomRightTile == null && this.insideX == 3 && tileChunkLocalX < 7) {
                                                            if (this.insideZ == 3) {
                                                                if (bottomRightChunk == null && tileChunkLocalZ < 7 && (bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1)) != null) {
                                                                    bottomRightChunk.setChanged(true);
                                                                }
                                                                bottomRightTile = bottomRightChunk != null ? bottomRightChunk.getTile(0, 0) : null;
                                                            } else {
                                                                if (rightChunk == null && (rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ)) != null) {
                                                                    rightChunk.setChanged(true);
                                                                }
                                                                MapTile mapTile4 = bottomRightTile = rightChunk != null ? rightChunk.getTile(0, this.insideZ + 1) : null;
                                                            }
                                                        }
                                                        if (bottomRightTile != null) {
                                                            bottomRightTile.getBlock(0, 0).setSlopeUnknown(true);
                                                        }
                                                    }
                                                } else if (xEdge) {
                                                    if (rightTile == null && this.insideX == 3 && rightChunk == null && tileChunkLocalX < 7) {
                                                        rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                                                        if (rightChunk != null) {
                                                            rightChunk.setChanged(true);
                                                        }
                                                        MapTile mapTile5 = rightTile = rightChunk != null ? rightChunk.getTile(0, this.insideZ) : null;
                                                    }
                                                    if (rightTile != null) {
                                                        rightTile.getBlock(0, z + 1).setSlopeUnknown(true);
                                                    }
                                                }
                                            }
                                            result = 3;
                                        }
                                    }
                                    mapTile.setWorldInterpretationVersion(1);
                                    tileChunk.setTile(this.insideX, this.insideZ, mapTile);
                                    mapTile.setWrittenOnce(true);
                                    mapTile.setLoaded(true);
                                    try {
                                        XaeroWorldMapCore.chunkCleanField.set(chunk, true);
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                        }
                    }
                    if (!tileChunk.includeInSave()) {
                        tileChunk = null;
                        region.setChunk(tileChunkX & 7, tileChunkZ & 7, null);
                    }
                }
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                object = region.writerThreadPauseSync;
                synchronized (object) {
                    if (tileChunk != null && !region.isWritingPaused()) {
                        boolean regionIsStillWritable = false;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            boolean bl = regionIsStillWritable = region.isResting() && region.getLoadState() == 2;
                            if (regionIsStillWritable) {
                                region.setBeingWritten(true);
                            }
                        }
                        if (tileChunk.wasChanged()) {
                            if (regionIsStillWritable) {
                                tileChunk.updateBuffers(this.mapProcessor, biomeColorCalculator, overlayManager, detailedDebug);
                                result += 2;
                                if (bottomChunk == null && tileChunkLocalZ < 7) {
                                    bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                                }
                                if (rightChunk == null && tileChunkLocalX < 7) {
                                    rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                                }
                                if (bottomRightChunk == null && tileChunkLocalX < 7 && tileChunkLocalZ < 7) {
                                    bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                                }
                                if (bottomChunk != null && bottomChunk.wasChanged()) {
                                    bottomChunk.updateBuffers(this.mapProcessor, biomeColorCalculator, overlayManager, detailedDebug);
                                    bottomChunk.setChanged(false);
                                    result += 2;
                                }
                                if (rightChunk != null && rightChunk.wasChanged()) {
                                    rightChunk.setToUpdateBuffers(true);
                                    rightChunk.setChanged(false);
                                }
                                if (bottomRightChunk != null && bottomRightChunk.wasChanged()) {
                                    bottomRightChunk.setToUpdateBuffers(true);
                                    bottomRightChunk.setChanged(false);
                                }
                            }
                            tileChunk.setChanged(false);
                        }
                    }
                }
                ++this.Z;
                if (this.Z > this.endTileChunkZ - this.startTileChunkZ) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > this.endTileChunkX - this.startTileChunkX) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
    }

    public int getSectionBasedHeight(Chunk bchunk, int startY) {
        ChunkSection searchedSection;
        int i;
        ChunkSection[] sections = bchunk.func_76587_i();
        int playerSection = startY >> 4;
        int result = -1;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection == Chunk.field_186036_a) continue;
            result = (i << 4) + 15;
        }
        if (playerSection > 0 && result == -1) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection == Chunk.field_186036_a) continue;
                result = (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public boolean isGlowing(BlockState state) {
        return (double)state.func_185906_d() >= 0.5;
    }

    public boolean shouldOverlay(BlockState state, FluidState fluidFluidState, int lightOpacity) {
        return state.func_177230_c() instanceof GlassBlock || lightOpacity != 255 && (fluidFluidState == null ? RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)RenderType.func_228645_f_()) : RenderTypeLookup.canRenderInLayer((FluidState)fluidFluidState, (RenderType)RenderType.func_228645_f_()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvisible(World world, BlockState state, Block b, boolean flowers) {
        if (!(b instanceof FlowingFluidBlock) && state.func_185901_i() == BlockRenderType.INVISIBLE) {
            return true;
        }
        if (b == Blocks.field_150478_aa) {
            return true;
        }
        if (b == Blocks.field_150349_c) {
            return true;
        }
        if (b instanceof DoublePlantBlock) {
            return true;
        }
        if ((b instanceof FlowerBlock || b instanceof DoublePlantBlock) && !flowers) {
            return true;
        }
        ArrayList<BlockState> arrayList = this.buggedStates;
        synchronized (arrayList) {
            if (this.buggedStates.contains(state)) {
                return true;
            }
        }
        MaterialColor materialColor = null;
        try {
            materialColor = state.func_185909_g((IBlockReader)world, (BlockPos)this.mutableGlobalPos);
        }
        catch (Throwable t) {
            ArrayList<BlockState> arrayList2 = this.buggedStates;
            synchronized (arrayList2) {
                this.buggedStates.add(state);
            }
            System.out.println("Broken vanilla map color definition found: " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b));
        }
        return materialColor == null || materialColor.field_76291_p == 0;
    }

    public void loadPixel(World world, MapBlock pixel, MapBlock currentPixel, Chunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean canReuseBiomeColours, MutableRegistry<Biome> biomeRegistry, boolean flowers) {
        int h;
        pixel.prepareForWriting();
        this.overlayBuilder.startBuilding();
        boolean underair = !cave;
        BlockState opaqueState = null;
        byte workingLight = -1;
        this.topH = lowY;
        this.mutableGlobalPos.func_181079_c((bchunk.func_76632_l().field_77276_a << 4) + insideX, lowY - 1, (bchunk.func_76632_l().field_77275_b << 4) + insideZ);
        for (h = highY; h >= lowY; --h) {
            Block b;
            this.mutableLocalPos.func_181079_c(insideX, h, insideZ);
            BlockState state = bchunk.func_180495_p((BlockPos)this.mutableLocalPos);
            FluidState fluidFluidState = bchunk.func_204610_c((BlockPos)this.mutableLocalPos);
            BlockState fluidState = fluidFluidState.func_206883_i();
            this.mutableGlobalPos.func_185336_p(h + 1);
            workingLight = (byte)world.func_226658_a_(LightType.BLOCK, (BlockPos)this.mutableGlobalPos);
            this.mutableGlobalPos.func_185336_p(h);
            if (!fluidFluidState.func_206888_e()) {
                underair = true;
                if (this.loadPixelHelp(pixel, currentPixel, world, fluidState, workingLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, fluidFluidState, biomeRegistry, flowers)) {
                    opaqueState = state;
                    break;
                }
            }
            if ((b = state.func_177230_c()) instanceof AirBlock) {
                underair = true;
                continue;
            }
            if (!underair || state == null || state.func_177230_c() == fluidState.func_177230_c() || !this.loadPixelHelp(pixel, currentPixel, world, state, workingLight, bchunk, insideX, insideZ, h, canReuseBiomeColours, cave, null, biomeRegistry, flowers)) continue;
            opaqueState = state;
            break;
        }
        if (h < lowY) {
            h = lowY;
        }
        BiomeKey blockBiome = null;
        BlockState state = opaqueState == null ? Blocks.field_150350_a.func_176223_P() : opaqueState;
        byte light = opaqueState == null ? (byte)0 : workingLight;
        this.overlayBuilder.finishBuilding(pixel);
        if (!canReuseBiomeColours || currentPixel == null || currentPixel.getState() != state) {
            blockBiome = this.colorTypeCache.getBlockBiomeColour(world, state, (BlockPos)this.mutableGlobalPos, this.biomeBuffer, null, biomeRegistry);
        } else {
            this.biomeBuffer[0] = currentPixel.getColourType();
            blockBiome = currentPixel.getBiome();
            this.biomeBuffer[2] = currentPixel.getCustomColour();
        }
        if (this.overlayBuilder.getOverlayBiome() != null) {
            blockBiome = this.overlayBuilder.getOverlayBiome();
        }
        boolean glowing = this.isGlowing(state);
        pixel.write(state, h, this.topH, this.biomeBuffer, blockBiome, light, glowing, cave);
    }

    private boolean loadPixelHelp(MapBlock pixel, MapBlock currentPixel, World world, BlockState state, byte light, Chunk bchunk, int insideX, int insideZ, int h, boolean canReuseBiomeColours, boolean cave, FluidState fluidFluidState, MutableRegistry<Biome> biomeRegistry, boolean flowers) {
        Block b = state.func_177230_c();
        if (this.shouldOverlay(state, fluidFluidState, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableGlobalPos))) {
            if (h > this.topH) {
                this.topH = h;
            }
            this.writerBiomeInfoSupplier.set(currentPixel, canReuseBiomeColours);
            this.overlayBuilder.build(state, this.biomeBuffer, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableGlobalPos), light, world, this.mapProcessor, (BlockPos)this.mutableGlobalPos, this.overlayBuilder.getOverlayBiome(), biomeRegistry, this.colorTypeCache, this.writerBiomeInfoSupplier);
            return false;
        }
        if (this.isInvisible(world, state, b, flowers)) {
            return false;
        }
        if (h > this.topH) {
            this.topH = h;
        }
        return true;
    }

    public int loadBlockColourFromTexture(BlockState state, boolean convert, World world, BlockPos globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.clearCachedColours = false;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Xaero's World Map cache cleared!");
            }
        }
        Integer c = this.blockColours.get(state);
        int red = 0;
        int green = 0;
        int blue = 0;
        Block b = state.func_177230_c();
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                List upQuads = null;
                BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                if (convert) {
                    upQuads = bms.func_178125_b(state).func_200117_a(state, Direction.UP, this.usedRandom);
                }
                TextureAtlasSprite missingTexture = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).func_195424_a(null);
                TextureAtlasSprite texture = upQuads == null || upQuads.isEmpty() || ((BakedQuad)upQuads.get(0)).func_187508_a() == missingTexture ? bms.func_178122_a(state) : ((BakedQuad)upQuads.get(0)).func_187508_a();
                name = texture.func_195668_m() + ".png";
                if (b instanceof OreBlock && b != Blocks.field_196766_fg) {
                    name = "minecraft:block/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);
                    InputStream input = resource.func_199027_b();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 0;
                    int ts = Math.min(img.getWidth(), img.getHeight());
                    if (ts > 0) {
                        int diff = Math.max(1, Math.min(4, ts / 8));
                        int parts = ts / diff;
                        for (int i = 0; i < parts; ++i) {
                            for (int j = 0; j < parts; ++j) {
                                int rgb = img.getRGB(i * diff, j * diff);
                                int alpha = rgb >> 24 & 0xFF;
                                if (rgb == 0 || alpha == 0) continue;
                                red += rgb >> 16 & 0xFF;
                                green += rgb >> 8 & 0xFF;
                                blue += rgb & 0xFF;
                                ++total;
                            }
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new SilentException("Black texture " + ts);
                    }
                    c = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(state, false, world, globalPos);
                }
                c = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos).field_76291_p;
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                WorldMap.LOGGER.info("Block file not found: " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b));
            }
            catch (Exception e) {
                c = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos).field_76291_p;
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Exception when loading " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b) + " texture, using material colour.");
                if (e instanceof SilentException) {
                    System.out.println(e.getMessage());
                }
                e.printStackTrace();
            }
            if (c != null) {
                this.blockColours.put(state, c);
            }
        }
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }

    public BlockStateColorTypeCache getColorTypeCache() {
        return this.colorTypeCache;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }
}

